/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import vazkii.botania.api.block.IAvatarTile;
import vazkii.botania.api.item.IAvatarWieldable;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.entity.EntityMagicMissile;
import vazkii.botania.common.entity.ModEntities;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.xplat.IXplatAbstractions;

public class ItemMissileRod
extends Item {
    private static final ResourceLocation avatarOverlay = new ResourceLocation("botania:textures/model/avatar_missile.png");
    private static final int COST_PER = 120;
    private static final int COST_AVATAR = 40;

    public ItemMissileRod(Item.Properties props) {
        super(props);
    }

    @Nonnull
    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public void m_5929_(Level world, LivingEntity living, ItemStack stack, int count) {
        if (!(living instanceof Player)) {
            return;
        }
        Player player = (Player)living;
        if (count != this.m_8105_(stack) && count % (ManaItemHandler.instance().hasProficiency(player, stack) ? 1 : 2) == 0 && ManaItemHandler.instance().requestManaExactForTool(stack, player, 120, false)) {
            if (!world.f_46443_ && ItemMissileRod.spawnMissile(world, (LivingEntity)player, player.m_20185_() + (Math.random() - 0.05), player.m_20186_() + 2.4 + (Math.random() - 0.05), player.m_20189_() + (Math.random() - 0.05))) {
                ManaItemHandler.instance().requestManaExactForTool(stack, player, 120, true);
            }
            SparkleParticleData data = SparkleParticleData.sparkle(6.0f, 1.0f, 0.4f, 1.0f, 6);
            world.m_7106_((ParticleOptions)data, player.m_20185_(), player.m_20186_() + 2.4, player.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    public static boolean spawnMissile(Level world, LivingEntity thrower, double x, double y, double z) {
        EntityMagicMissile missile = thrower != null ? new EntityMagicMissile(thrower, false) : (EntityMagicMissile)ModEntities.MAGIC_MISSILE.m_20615_(world);
        missile.m_6034_(x, y, z);
        if (missile.findTarget()) {
            if (!world.f_46443_) {
                missile.m_5496_(world.f_46441_.nextInt(100) == 0 ? ModSounds.missileFunny : ModSounds.missile, 1.0f, 0.8f + (float)Math.random() * 0.2f);
                world.m_7967_((Entity)missile);
            }
            return true;
        }
        return false;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @Nonnull InteractionHand hand) {
        return ItemUtils.m_150959_((Level)world, (Player)player, (InteractionHand)hand);
    }

    public static class AvatarBehavior
    implements IAvatarWieldable {
        @Override
        public void onAvatarUpdate(IAvatarTile tile) {
            BlockEntity te = (BlockEntity)tile;
            Level world = te.m_58904_();
            BlockPos pos = te.m_58899_();
            IManaReceiver receiver = IXplatAbstractions.INSTANCE.findManaReceiver(world, te.m_58899_(), te.m_58900_(), te, null);
            if (receiver.getCurrentMana() >= 40 && tile.getElapsedFunctionalTicks() % 3 == 0 && tile.isEnabled() && ItemMissileRod.spawnMissile(world, null, (double)pos.m_123341_() + 0.5 + (Math.random() - 0.05), (double)pos.m_123342_() + 2.5 + (Math.random() - 0.05), (double)pos.m_123343_() + (Math.random() - 0.05))) {
                if (!world.f_46443_) {
                    receiver.receiveMana(-40);
                }
                SparkleParticleData data = SparkleParticleData.sparkle(6.0f, 1.0f, 0.4f, 1.0f, 6);
                world.m_7106_((ParticleOptions)data, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 2.5, (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
            }
        }

        @Override
        public ResourceLocation getOverlayResource(IAvatarTile tile) {
            return avatarOverlay;
        }
    }
}

